/**
	moiforth - moi's forth interpreter

*/



#include <stdio.h>



#define CODE_END 0
#define CODE_PUSH -1
#define CODE_PLUS -2
#define CODE_PRINT -3
#define CODE_IF -4
#define CODE_ELSE   -5
#define CODE_THEN   -6



char stack[100];                /* å */
int pos;                        /* åΰ֥ݥ */

char prog[100];                 /* ץǼΰ */
int prog_cnt;                   /* ץ५ */

char if_stack[10];              /* ʬå */
int if_pos;                     /* ʬåΰ֥ݥ */



/* ͤ򥹥åѤ */
void push(char val)
{
    stack[pos] = val;
    pos--;
}



/* åͤФ */
char pop(void)
{
    pos++;
    return stack[pos];
}



/* ʬåϤѤ */
void push_if_stack(char adrs)
{
    if_stack[if_pos] = adrs;
    if_pos--;
}



/* ʬåϤФ */
char pop_if_stack(void)
{
    if_pos++;
    return if_stack[if_pos];
}



/* û */
void plus(void)
{
    char a, b, c;

    a = pop();
    b = pop();

    c = a + b;

    push(c);
}



/* ɽ */
void print(void)
{
    char a;

    a = pop();
    printf("%d\n", a);
}



/* ץ¹Ԥ */
void proc_prog(void)
{
    while (prog[prog_cnt] != CODE_END) {
        switch (prog[prog_cnt]) {
        case CODE_PUSH:
            push(prog[prog_cnt + 1]);
            prog_cnt += 2;
            break;

        case CODE_PLUS:
            plus();
            prog_cnt++;
            break;

        case CODE_PRINT:
            print();
            prog_cnt++;
            break;

        case CODE_IF:
            if (pop()) {
                prog_cnt += 2;

            } else {
                prog_cnt = prog[prog_cnt + 1];

            }
            break;

        case CODE_ELSE:
            prog_cnt = prog[prog_cnt + 1];
            break;

        case CODE_THEN:
            prog_cnt++;
            break;

        default:
            printf("undefined code: %d\n", prog[prog_cnt]);
            exit(1);
            break;

        }
    }
}



/*  */
void init(void)
{
    int j;

    for (j = 0; j < sizeof(prog) / sizeof(char); j++) {
        prog[j] = CODE_END;
    }

    prog_cnt = 0;

    pos = sizeof(stack) / sizeof(char) - 1;
    if_pos = sizeof(if_stack) / sizeof(char) - 1;
}



/* ڤ국ΤȤ1֤ */
char is_separator(char c)
{
    switch (c) {
    case ' ':
    case '\xd':
    case '\xa':
    case '\t':
        return 1;
        break;

    default:
        return 0;
        break;
    }
}



/* ȡڤФ */
void get_token(FILE * fp, char *token)
{
    int c;
    int j = 0;

    token[0] = '\x0';

    /* ѿ椬ޤɤ߹ */
    c = fgetc(fp);
    while (is_separator(c) && !feof(fp)) {
        c = fgetc(fp);
    }

    /* ڤ국ޤǤɤ߹ */
    while (!is_separator(c) && !feof(fp)) {
        token[j] = c;
        j++;
        c = fgetc(fp);
    }

    token[j] = '\x0';
}



/* ʸ󤬿ΤȤ1֤ */
int isnumber(char *str)
{
    while (*str != '\x0') {
        if (!isdigit(*str)) {
            return 0;
        }
        str++;
    }

    return 1;
}



/* ʸϤ */
void parse(char *fname)
{
    FILE *fp;
    char token[100];
    int idx = 0;

    fp = fopen(fname, "r");

    get_token(fp, token);
    while (token[0] != '\x0' || !feof(fp)) {
        if (strcmp(token, "+") == 0) {
            prog[idx] = CODE_PLUS;
            idx++;

        } else if (strcmp(token, ".") == 0) {
            prog[idx] = CODE_PRINT;
            idx++;

        } else if (isnumber(token)) {
            prog[idx] = CODE_PUSH;
            prog[idx + 1] = atoi(token);
            idx += 2;

        } else if (strcmp(token, "if") == 0) {
            prog[idx] = CODE_IF;
            push_if_stack(idx + 1);
            idx += 2;

        } else if (strcmp(token, "else") == 0) {
            prog[idx] = CODE_ELSE;
            prog[pop_if_stack()] = idx + 2;
            push_if_stack(idx + 1);
            idx += 2;

        } else if (strcmp(token, "then") == 0) {
            prog[idx] = CODE_THEN;
            prog[pop_if_stack()] = idx + 1;
            idx++;

        } else {
            printf("undefined word: %s\n", token);
            exit(1);

        }

        get_token(fp, token);
    }

    prog[idx] = CODE_END;

    fclose(fp);
}



int main(int argc, char *argv[])
{
    init();

    parse(argv[1]);

    proc_prog();

    return 0;
}
