/**
	moiforth - moi's forth interpreter

*/



#include <stdio.h>



#define CODE_END 0
#define CODE_PUSH -1
#define CODE_PLUS -2
#define CODE_PRINT -3
#define CODE_IF -4
#define CODE_ELSE   -5
#define CODE_THEN   -6
#define CODE_DO -7
#define CODE_LOOP -8
#define CODE_I -9
#define CODE_CR -10



#define PS(s) printf((s));
#define PN(s,n) printf((s),(n));



char stack[100];                /* å */
int pos;                        /* åΰ֥ݥ */

char prog[100];                 /* ץǼΰ */
int prog_cnt;                   /* ץ५ */

char branch_stack[10];          /* ʬå */
int branch_pos;                 /* ʬåΰ֥ݥ */

char loop_cnt_stack[10];        /* 롼ץѥå */
char loop_end_stack[10];        /* 롼׽λѥå */
int loop_pos;                   /* 롼ץåΰ֥ݥ */



/* ͤ򥹥åѤ */
void push(char val)
{
    pos--;
    stack[pos] = val;
}



/* åͤФ */
char pop(void)
{
    return stack[pos++];
}



/* ʬåϤѤ */
void push_branch_stack(char adrs)
{
    branch_pos--;
    branch_stack[branch_pos] = adrs;
}



/* ʬåϤФ */
char pop_branch_stack(void)
{
    return branch_stack[branch_pos++];
}



/* û */
void plus(void)
{
    char a, b, c;

    a = pop();
    b = pop();

    c = a + b;

    push(c);
}



/* ɽ */
void print(void)
{
    char a;

    a = pop();
    printf("%d", a);
}



/* 'do'¹Ԥ */
void call_do(void)
{
    loop_pos--;

    /* åƤ롼ץå */
    loop_cnt_stack[loop_pos] = pop();
    loop_end_stack[loop_pos] = pop();
}



/* 'loop'¹Ԥ */
void call_loop(void)
{
    loop_cnt_stack[loop_pos]++;
    if (loop_cnt_stack[loop_pos] >= loop_end_stack[loop_pos]) {
        /* 롼פȴ */
        loop_pos++;
        prog_cnt += 2;

    } else {
        /* 롼Ƭ */
        prog_cnt = prog[prog_cnt + 1];

    }
}



/* 'i'¹Ԥ */
void call_i(void)
{
    /* å˰¦Υ롼ץ󥿤push */
    push(loop_cnt_stack[loop_pos]);
    prog_cnt++;
}



/* 'cr'¹Ԥ */
void call_cr(void)
{
    printf("\n");
    prog_cnt++;
}



/* ץ¹Ԥ */
void proc_prog(void)
{
    while (prog[prog_cnt] != CODE_END) {
        switch (prog[prog_cnt]) {
        case CODE_PUSH:
            push(prog[prog_cnt + 1]);
            prog_cnt += 2;
            break;

        case CODE_PLUS:
            plus();
            prog_cnt++;
            break;

        case CODE_PRINT:
            print();
            prog_cnt++;
            break;

        case CODE_IF:
            if (pop()) {
                prog_cnt += 2;

            } else {
                prog_cnt = prog[prog_cnt + 1];

            }
            break;

        case CODE_ELSE:
            prog_cnt = prog[prog_cnt + 1];
            break;

        case CODE_THEN:
            prog_cnt++;
            break;

        case CODE_DO:
            call_do();
            prog_cnt++;
            break;

        case CODE_LOOP:
            call_loop();
            break;

        case CODE_I:
            call_i();
            break;

        case CODE_CR:
            call_cr();
            break;

        default:
            printf("undefined code: %d\n", prog[prog_cnt]);
            exit(1);
            break;

        }
    }
}



/*  */
void init(void)
{
    int j;

    for (j = 0; j < sizeof(prog) / sizeof(char); j++) {
        prog[j] = CODE_END;
    }

    prog_cnt = 0;

    pos = sizeof(stack) / sizeof(char);
    branch_pos = sizeof(branch_stack) / sizeof(char);
    loop_pos = sizeof(loop_cnt_stack) / sizeof(char);

}



/* ڤ국ΤȤ1֤ */
char is_separator(char c)
{
    switch (c) {
    case ' ':
    case '\xd':
    case '\xa':
    case '\t':
        return 1;
        break;

    default:
        return 0;
        break;
    }
}



/* ȡڤФ */
void get_token(FILE * fp, char *token)
{
    int c;
    int j = 0;

    token[0] = '\x0';

    /* ѿ椬ޤɤ߹ */
    c = fgetc(fp);
    while (is_separator(c) && !feof(fp)) {
        c = fgetc(fp);
    }

    /* ڤ국ޤǤɤ߹ */
    while (!is_separator(c) && !feof(fp)) {
        token[j] = c;
        j++;
        c = fgetc(fp);
    }

    token[j] = '\x0';
}



/* ʸ󤬿ΤȤ1֤ */
int isnumber(char *str)
{
    while (*str != '\x0') {
        if (!isdigit(*str)) {
            return 0;
        }
        str++;
    }

    return 1;
}



/* ʸϤ */
void parse(char *fname)
{
    FILE *fp;
    char token[100];
    int idx = 0;

    fp = fopen(fname, "r");

    get_token(fp, token);
    while (token[0] != '\x0' || !feof(fp)) {
        if (strcmp(token, "+") == 0) {
            prog[idx] = CODE_PLUS;
            idx++;

        } else if (strcmp(token, ".") == 0) {
            prog[idx] = CODE_PRINT;
            idx++;

        } else if (isnumber(token)) {
            prog[idx] = CODE_PUSH;
            prog[idx + 1] = atoi(token);
            idx += 2;

        } else if (strcmp(token, "if") == 0) {
            prog[idx] = CODE_IF;
            push_branch_stack(idx + 1);
            idx += 2;

        } else if (strcmp(token, "else") == 0) {
            prog[idx] = CODE_ELSE;
            prog[pop_branch_stack()] = idx + 2;
            push_branch_stack(idx + 1);
            idx += 2;

        } else if (strcmp(token, "then") == 0) {
            prog[idx] = CODE_THEN;
            prog[pop_branch_stack()] = idx + 1;
            idx++;

        } else if (strcmp(token, "do") == 0) {
            prog[idx] = CODE_DO;
            push_branch_stack(idx + 1);
            idx++;

        } else if (strcmp(token, "loop") == 0) {
            prog[idx] = CODE_LOOP;
            prog[idx + 1] = pop_branch_stack();
            idx += 2;

        } else if (strcmp(token, "i") == 0) {
            prog[idx] = CODE_I;
            idx++;

        } else if (strcmp(token, "cr") == 0) {
            prog[idx] = CODE_CR;
            idx++;

        } else {
            printf("undefined word: %s\n", token);
            exit(1);

        }

        get_token(fp, token);
    }

    prog[idx] = CODE_END;

    fclose(fp);
}



int main(int argc, char *argv[])
{
    init();

    parse(argv[1]);

    proc_prog();

    return 0;
}
