/**
 * moiforth - moi's forth interpreter.
 *
 * @file main.c
 */



#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>



/**
 * z}Ṽ}VR[h
 */
#define CODE_END 0
#define CODE_PUSH -1
#define CODE_PLUS -2
#define CODE_PRINT -3
#define CODE_IF -4
#define CODE_ELSE   -5
#define CODE_THEN   -6
#define CODE_DO -7
#define CODE_LOOP -8
#define CODE_I -9
#define CODE_CR -10
#define CODE_CALL -11
#define CODE_RET -12



#define WORD_HEAP_SIZE (sizeof(word_heap) / sizeof(char))       /**< [ho^̈̃TCY */



#define PS(s) printf((s));      /**< fobOp */
#define PN(s,n) printf((s),(n));        /**< fobOp */



const char *sep = " \t\n\xd\xa";    /**< \͂̋؂q */



/**
 * [h-Ԓn̑g
 */
typedef struct word_proc_table {
    char word_pointer;          /**< [ho^ꂽq[vւ̔Ԓn */
    char proc_pointer;          /**< o^ꂽԒn */
} WORD_PROC_TABLE;



char stack[100];                /**< X^bN */
int pos;                        /**< X^bN̈ʒu|C^ */

char prog[100];                 /**< vOi[̈ */
int prog_cnt;                   /**< vOJE^ */
int base_prog_cnt;              /**< vOJE^̏ʒu */

char branch_stack[10];          /**< X^bN */
int branch_pos;                 /**< X^bN̈ʒu|C^ */

char loop_cnt_stack[10];        /**< [vJE^pX^bN */
char loop_end_stack[10];        /**< [vIlpX^bN */
int loop_pos;                   /**< [vX^bN̈ʒu|C^ */

char word_heap[100];            /**< [ho^̈ */
unsigned char word_heap_index;           /**< [ho^̖̈gp̈̐擪w */

WORD_PROC_TABLE word_proc[100]; /**< [hƊ蓖ăR[h̑Ή\ */
unsigned char word_proc_head;            /**< Ή\̖gpʒu̐擪 */

char word_first_pos;            /**< [ho^̐擪Ԓn */

char quit_enabled;                              /**< Θb甲oƂ1 */



/** 
 * lX^bNɐς
 */
void push(char val)
{
    pos--;
    stack[pos] = val;
}



/**
 * X^bNlo
 */
char pop(void)
{
    return stack[pos++];
}



/** 
 * X^bNɔԒnς
 */
void push_branch_stack(char adrs)
{
    branch_pos--;
    branch_stack[branch_pos] = adrs;
}



/** 
 * X^bNԒno
 */
unsigned char pop_branch_stack(void)
{
    return branch_stack[branch_pos++];
}



/** 
 * Z
 */
void plus(void)
{
    char a, b, c;

    a = pop();
    b = pop();

    c = a + b;

    push(c);
}



/** 
 * \
 */
void print(void)
{
    char a;

    a = pop();
    printf("%d", a);
}



/** 
 * [h'do's
 */
void call_do(void)
{
    loop_pos--;

    /* X^bN̓e[vX^bNɓ */
    loop_cnt_stack[loop_pos] = pop();
    loop_end_stack[loop_pos] = pop();
}



/** 
 * [h'loop's
 */
void call_loop(void)
{
    loop_cnt_stack[loop_pos]++;
    if (loop_cnt_stack[loop_pos] >= loop_end_stack[loop_pos]) {
        /* [v𔲂 */
        loop_pos++;
        prog_cnt += 2;

    } else {
        /* [v擪ɖ߂ */
        prog_cnt = prog[prog_cnt + 1];

    }
}



/** 
 * [h'i's
 */
void call_i(void)
{
    /* X^bNɈԓ̃[vJE^push */
    push(loop_cnt_stack[loop_pos]);
    prog_cnt++;
}



/** 
 * [h'cr's
 */
void call_cr(void)
{
    printf("\n");
    prog_cnt++;
}



/** 
 * vOs
 */
void proc_prog(void)
{
    prog_cnt = base_prog_cnt;

    while (prog[prog_cnt] != CODE_END) {
        switch (prog[prog_cnt]) {
        case CODE_PUSH:
            push(prog[prog_cnt + 1]);
            prog_cnt += 2;
            break;

        case CODE_PLUS:
            plus();
            prog_cnt++;
            break;

        case CODE_PRINT:
            print();
            prog_cnt++;
            break;

        case CODE_IF:
            if (pop()) {
                prog_cnt += 2;

            } else {
                prog_cnt = prog[prog_cnt + 1];

            }
            break;

        case CODE_ELSE:
            prog_cnt = prog[prog_cnt + 1];
            break;

        case CODE_THEN:
            prog_cnt++;
            break;

        case CODE_DO:
            call_do();
            prog_cnt++;
            break;

        case CODE_LOOP:
            call_loop();
            break;

        case CODE_I:
            call_i();
            break;

        case CODE_CR:
            call_cr();
            break;

        case CODE_CALL:
            push_branch_stack(prog_cnt);
            prog_cnt = prog[prog_cnt + 1];
            break;

        case CODE_RET:
            prog_cnt = pop_branch_stack();
            prog_cnt++;
            break;

        default:
            printf("undefined cnt: %d, code: %d\n", prog_cnt,
                   prog[prog_cnt]);
            exit(1);
            break;

        }
    }
}



/** 
 * 
 */
void init(void)
{
    int j;

    for (j = 0; j < sizeof(prog) / sizeof(char); j++) {
        prog[j] = CODE_END;
    }

    prog_cnt = 0;
    base_prog_cnt = 0;
    word_heap_index = 0;
    word_proc_head = 0;

    pos = sizeof(stack) / sizeof(char);
    branch_pos = sizeof(branch_stack) / sizeof(char);
    loop_pos = sizeof(loop_cnt_stack) / sizeof(char);

    quit_enabled = 0;
}



/** 
 * [ho^.
 *
 * @param str
 * @return o^̃q[v̐擪ʒu
 */
char reg_word_name(char *str)
{
    char reg_pos = word_heap_index;

    /* Rs[ */
    while (*str != '\x0') {
        word_heap[word_heap_index++] = *str++;
    }

    /* I[ */
    word_heap[word_heap_index++] = '\x0';

    /* o^̐擪ʒuԂ */
    return reg_pos;
}



/** 
 * ؂L̂ƂA1Ԃ
 */
char is_separator(char c)
{
    switch (c) {
    case ' ':
    case '\xd':
    case '\xa':
    case '\t':
        return 1;
        break;

    default:
        return 0;
        break;
    }
}



/** 
 * 񂪐̂Ƃ1Ԃ
 */
int isnumber(char *str)
{
    while (*str != '\x0') {
        if (!isdigit(*str)) {
            return 0;
        }
        str++;
    }

    return 1;
}



/**
 * [hƏԒnƂ֘At
 * @param[in] name o^[h
 */
void assoc_word_name(unsigned char *name)
{
    /* [hq[v̈ɓo^ */
    word_proc[word_proc_head].word_pointer = reg_word_name(name);

    /* ̎_̃vOʒuo^([h̊JnʒuɂȂ) */
    word_proc[word_proc_head].proc_pointer = prog_cnt;

    /* gĂȂo^e[u擪ɂ */
    word_proc_head++;
}



/**
 * Ŏw肵[h̃vOʒuԂ
 */
char get_word_address(char *name)
{
    unsigned char j;

    for (j = 0; j < 100; j++) {
        unsigned char heap_index = word_proc[j].word_pointer;

        if (strcmp(&word_heap[heap_index], name) == 0) {
            return j;
        }
    }

    return -1;
}



/** 
 * \͂
 */
void parse(char *cmd)
{
    char *token;
    char adrs;
    int idx = 0;

    token = strtok(cmd, sep);
    while (token != NULL) {
        if (strcmp(token, "+") == 0) {
            prog[idx] = CODE_PLUS;
            idx++;

        } else if (strcmp(token, ".") == 0) {
            prog[idx] = CODE_PRINT;
            idx++;

        } else if (isnumber(token)) {
            prog[idx] = CODE_PUSH;
            prog[idx + 1] = atoi(token);
            idx += 2;

        } else if (strcmp(token, "if") == 0) {
            prog[idx] = CODE_IF;
            push_branch_stack(idx + 1);
            idx += 2;

        } else if (strcmp(token, "else") == 0) {
            prog[idx] = CODE_ELSE;
            prog[pop_branch_stack()] = idx + 2;
            push_branch_stack(idx + 1);
            idx += 2;

        } else if (strcmp(token, "then") == 0) {
            prog[idx] = CODE_THEN;
            prog[pop_branch_stack()] = idx + 1;
            idx++;

        } else if (strcmp(token, "do") == 0) {
            prog[idx] = CODE_DO;
            push_branch_stack(idx + 1);
            idx++;

        } else if (strcmp(token, "loop") == 0) {
            prog[idx] = CODE_LOOP;
            prog[idx + 1] = pop_branch_stack();
            idx += 2;

        } else if (strcmp(token, "i") == 0) {
            prog[idx] = CODE_I;
            idx++;

        } else if (strcmp(token, "cr") == 0) {
            prog[idx] = CODE_CR;
            idx++;

        } else if (strcmp(token, ":") == 0) {
            /* :̎̒P[hƂ */
            token = strtok(NULL, sep);
            assoc_word_name(token);

        } else if (strcmp(token, ";") == 0) {
            /* [hI[R[hǉ */
            prog[idx] = CODE_RET;
            idx++;
            //prog_cnt = idx;
            base_prog_cnt = idx;

        } else if ((adrs = get_word_address(token)) >= 0) {
            /* [U`[hĂяo𖄂ߍ */
            prog[idx] = CODE_CALL;
            prog[idx + 1] = adrs;
            idx += 2;

        } else {
            printf("undefined word: %s\n", token);
            exit(1);

        }

        token = strtok(NULL, sep);
    }

    prog[idx] = CODE_END;

}



/**
 * ForthŏꂽvO[h
 */
void load_prog(char *fname, char *cmd)
{
    FILE *fp;
    unsigned int idx = 0;
    char c;

    fp = fopen(fname, "r");

    while ((c = fgetc(fp)) != EOF) {
        cmd[idx++] = c;
    }

    cmd[idx] = '\x0';

    fclose(fp);
}



int main(int argc, char *argv[])
{
    char cmd_buf[100];

    init();

    if (argc >= 2) {
        load_prog(argv[1], cmd_buf);
        parse(cmd_buf);

        proc_prog();

    } else {
        while (!quit_enabled) {
            printf(">");
            scanf("%100[^\n]%*[^\n]", cmd_buf);
            getchar();

            parse(cmd_buf);
            proc_prog();
        }

    }

    return 0;
}
