/**
	moiforth - moi's forth interpreter

*/



#define CODE_END 0
#define CODE_PUSH -1
#define CODE_PLUS -2
#define CODE_PRINT -3



char stack[100];	/* å */
int pos;	/* åΰ֥ݥ */

char prog[100];		/* ץǼΰ */
int prog_cnt;	/* ץ५ */



/* ͤ򥹥åѤ */
void push(char val)
{
	stack[pos] = val;
	pos--;
}



/* åͤФ */
char pop(void)
{
	pos++;
	return stack[pos];
}



/* û */
void plus(void)
{
	char a, b, c;

	a = pop();
	b = pop();

	c = a + b;

	push(c);
}



/* ɽ */
void print(void)
{
	char a;
	
	a = pop();
	printf("%d\n", a);
}



/* ץ¹Ԥ */
void proc_prog(void)
{
	while (prog[prog_cnt] != CODE_END) {
		switch (prog[prog_cnt]) {
		case CODE_PUSH:
			push(prog[prog_cnt + 1]);
			prog_cnt += 2;
			break;

		case CODE_PLUS:
			plus();
			prog_cnt++;
			break;

		case CODE_PRINT:
			print();
			prog_cnt++;
			break;

		}
	}
}



/*  */
void init(void)
{
	prog[0] = CODE_PUSH;
	prog[1] = 4;
	prog[2] = CODE_PUSH;
	prog[3] = 5;
	prog[4] = CODE_PLUS;
	prog[5] = CODE_PRINT;
	prog[6] = CODE_END;

	prog_cnt = 0;

	pos = sizeof(stack)/sizeof(char) - 1;
}



int main(void)
{
	init();

	proc_prog();

	return 0;
}

